import { Injectable } from '@angular/core';
import { BehaviorSubject } from 'rxjs';

export interface NotificationData {
    type: string;
    title: string;
    message: string;
}

@Injectable({
    providedIn: 'root'
})

export class NotificationService {
    notification = new BehaviorSubject<null | NotificationData>(null);

    constructor() { }

    open(data: NotificationData) {
        this.notification.next(data);
    }
}
