import { CommonModule } from '@angular/common';
import { NgModule } from '@angular/core';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { FormControlErrorModule } from '@app/shared/components/form-control-error/form-control-error.module';
import { RecaptchaFormsModule, RecaptchaModule } from 'ng-recaptcha';
import { MessageComponent } from './message.component';

@NgModule({
  declarations: [MessageComponent],
  imports: [
    CommonModule,
    ReactiveFormsModule,
    FormsModule,
    FormControlErrorModule,
    RecaptchaModule,
    RecaptchaFormsModule,
  ],
  exports: [MessageComponent],
})
export class MessageModule {}
