import { Component, OnInit } from '@angular/core';
import { FormControl, FormGroup, Validators } from '@angular/forms';
import { MatDialogRef } from '@angular/material/dialog';
import { APIService } from '@app/shared/services/api.service';
import { NotificationService } from '@app/shared/services/notification.service';

@Component({
  selector: 'app-message',
  templateUrl: './message.component.html',
  styleUrls: ['./message.component.scss'],
})
export class MessageComponent implements OnInit {
  feedBackForm: FormGroup = new FormGroup({
    email: new FormControl('', [Validators.required, Validators.email]),
    address: new FormControl('', [Validators.required, Validators.maxLength(35)]),
    title: new FormControl('', [Validators.required, Validators.maxLength(64)]),
    message: new FormControl('', [Validators.required, Validators.maxLength(500)]),
    recaptchaToken: new FormControl(Validators.required),
  });

  busy = false;

  constructor(
    public dialogRef: MatDialogRef<MessageComponent>,
    private readonly apiService: APIService,
    private notificationService: NotificationService,
  ) { }

  ngOnInit(): void { }

  close(): void {
    this.dialogRef.close();
  }

  submit(): void {
    this.busy = true;
    if (this.feedBackForm.invalid) {
      return;
    }
    const data = this.feedBackForm.value;
    this.apiService.registerProject(data).then((res) => {
      this.busy = false;
      this.feedBackForm.reset();
      const notification = { type: 'success', title: 'Thank You!', message: 'Your message has been sent.' };
      this.dialogRef.close();
      this.notificationService.open(notification);

    }, (error) => {
      this.busy = false;
      this.feedBackForm.reset();
      const notification = { type: 'error', title: 'Unfortunately your message was not sent.', message: 'Please try again.' };
      this.dialogRef.close();
      this.notificationService.open(notification);
    });
  }
}
