import { Component, Input, OnChanges } from '@angular/core';
@Component({
  selector: 'app-form-control-error',
  templateUrl: './form-control-error.component.html',
  styleUrls: ['./form-control-error.component.scss'],
})
export class FormControlErrorComponent implements OnChanges {
  @Input() fieldName = '';
  @Input() patternName = '';
  @Input() errors: any;

  errorMessage = '';

  constructor() {}

  ngOnChanges(): void {
    this.createErrorMessage();
  }

  createErrorMessage(): void {
    if (!this.errors) {
      return;
    }

    const errorsMap = this.makeErrors();
    const errorsKeys = Object.keys(this.errors);
    const messageKey = this.patternName || errorsKeys[0];
    this.errorMessage = errorsMap.get(messageKey) || `Error doesn't exists`;
  }

  makeErrors(): Map<string, string> {
    const fieldName = this.fieldName ? `${this.fieldName}` : 'Field';

    return new Map([
      ['required', `${fieldName} is required`],
      ['requiredTrue', `${fieldName} is required.`],
      ['number', `${fieldName} allows only whole numbers.`],
      ['letter', `${fieldName} allows only letters.`],
      ['email', `${fieldName} must be a valid email.`],
      ['address', `${fieldName} is invalid.`],
      ['minlength', `${fieldName} must be at least ${this.errors?.minlength?.requiredLength} characters.`],
      ['max', `${fieldName} value must be no more than ${this.errors?.max?.max}.`],
      ['maxlength', `${fieldName} must not exceed ${this.errors?.maxlength?.requiredLength} characters.`],
      ['pattern', `${fieldName} is invalid.`],
      [
        'passwordPattern',
        `${fieldName} must be 8-14 characters long.
      Must contain at least one uppercase alphanumeric letter and number.`,
      ],
      ['termsPattern', `You should agree with our ${fieldName}.`],
      ['invitePattern', `${fieldName} had been already used.`],
      ['mustMatch', `${fieldName} and password should be equal.`],
      ['wrongPassword', `${fieldName} is incorrect.`],
      ['invalidAddress', `${fieldName} is incorrect.`],
      ['invalidChainAddress', 'Blockchain address is not valid.'],
      ['min', `Minimal allowed ${fieldName} is ${this.errors?.min?.min}.`],
    ]);
  }
}
