import { AbstractControl, ValidatorFn } from "@angular/forms";
import domainNames from './tld.json';

export class CustomValidators {


    public static match(equalTo: AbstractControl): ValidatorFn {
        return (control: AbstractControl): { [key: string]: any } => {
            let val = control.value;

            if (val === undefined || val === null || val.trim() == "") {
                // won't check if empty
                return null;
            }

            if (val != equalTo.value) {
                return { "match": true };
            }

            return null;
        }
    }
    
    public static registred(): ValidatorFn {
        return (control: AbstractControl): { [key: string]: any } => {

            let val = control.value;

            if (val === undefined || val === null || val.trim() == "") {
                // won't check if empty
                return null;
            }
            
            var extension = val.substr(val.lastIndexOf(".") + 1);

            if (Object.values(domainNames).indexOf(extension, 0) === -1) {
                return { "registred": true };
            }
            
            return null;
        }
    }
}
