import { StepService } from './services/SharedService';
import { RegistrationConfirm } from './modals/registration-confirm/RegistrationConfirmComponent';
import { TickerDirective } from './directives/ticker.directive';
import { BrowserModule } from '@angular/platform-browser';
import { NgModule, ModuleWithProviders } from '@angular/core';
import { CommonModule } from '@angular/common';
import { NgbModule, NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { FormsModule } from '@angular/forms';
import { ReactiveFormsModule } from '@angular/forms';
import { FontAwesomeModule } from '@fortawesome/angular-fontawesome';
import { RouterModule } from '@angular/router';

import { ClipboardModule } from 'ngx-clipboard';



@NgModule({
    declarations: [
        TickerDirective,
        RegistrationConfirm,
    ],
    exports: [
        CommonModule,
        NgbModule,
        FormsModule,
        TickerDirective,
        ReactiveFormsModule,
        RegistrationConfirm,
        FontAwesomeModule,
        ClipboardModule,
        
    ],
    entryComponents: [
        RegistrationConfirm,


      ],
    imports: [
        CommonModule,
        NgbModule,
        ReactiveFormsModule,
        FontAwesomeModule,
        RouterModule,
        ClipboardModule,
        FormsModule
    ]
})
export class SharedModule {
    static forRoot(): ModuleWithProviders {
        return {
            ngModule: SharedModule,
            providers: [
           
                StepService
            ]
        };
    }
}