import { Component, OnInit } from '@angular/core';
import { FormGroup, FormBuilder, Validators } from '@angular/forms';

import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { RegistrationConfirm } from 'src/app/shared/modals/registration-confirm/RegistrationConfirmComponent';
import { CustomValidators } from 'src/app/shared/validators/CustomValidators';

@Component({
  selector: 'app-page-register',
  templateUrl: './register-component.html',
  styleUrls: ['./register-component.scss']
})
export class RegisterComponent {

  title = 'Register';

  public corporationForm: Boolean = false;
  public registerForm: FormGroup;
  public domainArray: any = [];

  constructor(
    private formBuilder: FormBuilder,
    private NgbModal: NgbModal
  ) {
    const password = this.formBuilder.control(null, [Validators.required, Validators.minLength(8), Validators.maxLength(14), Validators.pattern(/^(?=.*[A-Z])(?=.*[0-9])(?=.{1,})/)]);
    const emailAddress = this.formBuilder.control(null,[Validators.required, Validators.email, CustomValidators.registred()])
    this.registerForm = this.formBuilder.group({
      corpName: [null,],
      regNumber: [null,],
      address: [null,],
      name: [null, Validators.required],
      surname: [null, Validators.required],
      email: emailAddress,
      password: password,
      passwordConfirm: [null, CustomValidators.match(password)],
      checkedTerms: [null, Validators.required]
    });
  }

  changeToPrivite() {
    this.corporationForm = false;
    this.registerForm.get('corpName').clearValidators();
    this.registerForm.get('corpName').updateValueAndValidity();
    this.registerForm.get('regNumber').clearValidators();
    this.registerForm.get('regNumber').updateValueAndValidity();
    this.registerForm.get('address').clearValidators();
    this.registerForm.get('address').updateValueAndValidity();
  }

  changeToCorporation() {
    this.corporationForm = true;
    this.registerForm.get('corpName').setValidators([Validators.required]);
    this.registerForm.get('corpName').updateValueAndValidity();
    this.registerForm.get('regNumber').setValidators([Validators.required]);
    this.registerForm.get('regNumber').updateValueAndValidity();
    this.registerForm.get('address').setValidators([Validators.required]);
    this.registerForm.get('address').updateValueAndValidity();
  }

  public register() { 
    
    if(this.registerForm.invalid) {
      return;
    }

    const formData: any = {
      corporationNumber: this.registerForm.get('corpName').value,
      registrationNumber: this.registerForm.get('regNumber').value,
      address: this.registerForm.get('address').value,
      name: this.registerForm.get('name').value,
      surname: this.registerForm.get('surname').value,
      email: this.registerForm.get('email').value,
      password: this.registerForm.get('password').value,
      agreeToTerms: this.registerForm.get('checkedTerms').value
    }



    
    this.NgbModal.open(RegistrationConfirm, { size: 'lg' });
    
    this.registerForm.reset();
  }
  test(){
    var stringetest: string = "t.e.st.@te..st.lv"
    var extension = stringetest.substr(stringetest.lastIndexOf(".") + 1);

    console.log(extension);
    
  }
}
