import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { MainLayoutService } from './layouts/main-layout/MainLayoutService';
import { PortalLayoutService } from './layouts/portal-layout/PortalLayoutService';
import { SpecifiedLayoutService } from './layouts/specified-layout/SpecifiedLayoutService';

const routes: Routes = [
  // {
  //   path: '',
  //   redirectTo: 'home',
  //   pathMatch: 'full',
  // },

  MainLayoutService.childRoutes([
    { 
      path: '', 
      loadChildren: './pages/home/HomeModule#HomeModule' 
    },
    { 
      path: 'solutions', 
      loadChildren: './pages/solutions/SolutionsModule#SolutionsModule' 
    },
    { 
      path: 'register', 
      loadChildren: './pages/register/RegisterModule#RegisterModule' 
    },
    // { 
    //   path: 'login', 
    //   loadChildren: './pages/login/LoginModule#LoginModule' 
    // },
    { 
      path: 'terms', 
      loadChildren: './pages/terms/TermsModule#TermsModule' 
    },
    { 
      path: 'about', 
      loadChildren: './pages/about/AboutModule#AboutModule'
    },
    { 
      path: 'contact', 
      loadChildren: './pages/contact/ContactModule#ContactModule' 
    },
  ]),
  PortalLayoutService.childRoutes([
    // { 
    //   path: 'dashboard', 
    //   loadChildren: './pages/dashboard/DashboardModule#DashboardModule'
    // },
    // { 
    //   path: 'createwallet', 
    //   loadChildren: './pages/create-wallet/CreateWalletModule#CreateWalletModule'
    // },
    // { 
    //   path: 'transaction', 
    //   loadChildren: './pages/transaction/TransactionModule#TransactionModule'
    // },
    // { 
    //   path: 'signwallet', 
    //   loadChildren: './pages/sign-wallet/SignWalletModule#SignWalletModule'
    // },
    // { 
    //   path: 'walletsettings', 
    //   loadChildren: './pages/wallet-settings/WalletSettingsModule#WalletSettingsModule'
    // },
    // { 
    //   path: 'message', 
    //   loadChildren: './pages/message/MessageModule#MessageModule'
    // },
    // { 
    //   path: 'identity', 
    //   loadChildren: './pages/profile-identity/ProfileIdentityModule#ProfileIdentityModule'
    // },
    // { 
    //   path: 'mobileapp',
    //   loadChildren: './pages/mobile-application/MobileApplicationModule#MobileApplicationModule'
    // },
    // { 
    //   path: 'security',
    //   loadChildren: './pages/security/SecurityModule#SecurityModule'
    // },
    // { 
    //   path: 'desktopapp',
    //   loadChildren: './pages/desktop-application/DesktopApplicationModule#DesktopApplicationModule'
    // },
    // { 
    //   path: 'test',
    //   loadChildren: './pages/wallets-list/WalletsListModule#WalletsListModule'
    // },
  ]),
  SpecifiedLayoutService.childRoutes([
    // { 
    //   path: 'specifiedlogin', 
    //   loadChildren: './pages/specified-login/SpecifiedLoginModule#SpecifiedLoginModule'
    // },
  ]),

  // Fallback when no prior route is matched
  { path: '**', redirectTo: 'home', pathMatch: 'full' }
];

@NgModule({
  imports: [RouterModule.forRoot(routes)],
  exports: [RouterModule]
})
export class AppRoutingModule { }
