import { BrowserModule } from '@angular/platform-browser';
import { NgModule, ModuleWithProviders } from '@angular/core';
import { CommonModule } from '@angular/common';
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import {TranslateModule} from '@ngx-translate/core';
import { ReactiveFormsModule, FormsModule } from '@angular/forms';
import { FontAwesomeModule } from '@fortawesome/angular-fontawesome';
import { FlexLayoutModule } from '@angular/flex-layout';
import { NgSelectModule } from '@ng-select/ng-select'

@NgModule({
    declarations: [],
    exports: [
        CommonModule,
        TranslateModule,
        NgbModule,
        ReactiveFormsModule,
        FontAwesomeModule,
        FlexLayoutModule,
        NgSelectModule,
        FormsModule
        

    ],
    entryComponents:[],
    imports: [
        FontAwesomeModule,
        FlexLayoutModule,
        FormsModule,
        NgSelectModule
        
    ],
})
export class SharedModule {
    static forRoot(): ModuleWithProviders {
        return {
            ngModule: SharedModule,
            providers: []
        };
    }
}