import { Component } from '@angular/core';




interface question {

  title: string,
  answer: string,

}


const QUESTIONS: question[] = [

  {
    title: 'What is NXA?',
    answer: 'NXA is a community-based blockchain project focusing on blockchain technology to address use cases in developing countries, particularly Africa. NXA utilizes blockchain technology and digital identity to digitize assets and to automate the management of digital assets (DAAP) using smart contracts.',
  },
  {
    title: 'Did NXA do an ICO (Initial Coin Offering) or Crowdsale?',
    answer: 'No, There was no Crowdsale. NXA tokens were earned through participation in the network.',
  },
  {
    title: 'How can I get NXA tokens?',
    answer: 'You can purchase NXA GAS tokens in the secondary market on various exchanges or apply for grants at the NXA Foundation. You can also earn NXA GAS tokens if you are NXA holder and you vote on various community network initiatives.',
  },
  {
    title: 'What does the NXA token enable a holder to do?',
    answer: 'Gives the right to access and use the network.',
  },
  {
    title: 'What is the NXA Foundation?',
    answer: 'Since NXA did not do an ICO and is decentralized in governance and management, the NXA Foundation will be dedicated to the technological R&D of the NXA platform.',
  },
  {
    title: 'What types of use cases will the NXA Foundation focus on?',
    answer: 'Developing country and African blockchain use cases (mobile banking for non-banked and under-banked, credit assessment, pre-pay services, usage based micro-financing, micro services, digital asset exchange, identity solutions, peer to peer lending, medical records, and merchant services).',
  },
  {
    title: 'How does  the NXA Foundation intend to fulfill its use case goals?',
    answer: 'Maintain informational website and blog for the NXA blockchain community, organize contests that promote new apps and technologies that use NXA as its underlying platform and provide links to authorized NXA code repositories.',
  },
  {
    title: 'Why does the NXA Foundation have an Advisory Board?',
    answer: 'Mauritius has created a sandbox for the simulation of nascent crypto platforms. To provide investors with a regulated environment for the safe custody of digital assets and to enable the exchange of digital assets, the Mauritius’ Financial Services Commission (Mauritius FSC) will be introducing two new licensable activities, namely: 1. Custodian of Digital Assets Licence. 2. Digital Asset Marketplace Licence. The Mauritius FSC will also be implementing guidelines for investment in cryptocurrencies as digital assets. A National Regulatory Sandbox License Committee is due to be setup, comprising representatives of the Bank of Mauritius (BoM), Mauritius FSC, Mauritius’ Economic Development Board (EDB) and Financial Intelligence Unit. The Committee will be tasked with considering all issues relating to the issuing of Regulatory Sandbox Licences (RSLs) for FinTech activities and to provide guidance on the regulatory framework. Applicants for FinTech activities will be required to have appropriate cyber security and cyber resilience policies and capacities in place. The Anti Money Laundering (AML) and terrorist financing framework for both banking and non-banking financial services will be updated to be compatible with developments in FinTech.',
  },


]


@Component({
  selector: 'app-faq',
  templateUrl: './faq-component.html',
  styleUrls: ['./faq-component.scss']
})
export class FAQComponent {
  title = 'faq';
  public questions: any = QUESTIONS;
  public collapsed: number[] = [];
}
