import { Routes, Route } from '@angular/router';
import { MainLayoutComponent } from './MainLayoutComponent';

/**
 * Provides helper methods to create routes.
 */
export class MainLayoutService {

  /**
   * Creates routes using the shell component and authentication.
   * @param routes The routes to add.
   * @return The new route using shell as the base.
   */
  static childRoutes(routes: Routes): Route {
    return {
      path: '',
      component: MainLayoutComponent,
      children: routes,
      //canActivate: [AuthenticationGuard],
      resolve: {}
    };
  }
}
