import { NgModule } from '@angular/core';
import { Routes, RouterModule, ExtraOptions } from '@angular/router';
import { MainLayoutService } from './layouts/main-layout/MainLayoutService';

const routes: Routes = [
  // {
  //   path: '',
  //   redirectTo: 'home',
  //   pathMatch: 'full',
  // },

  MainLayoutService.childRoutes([
    { 
      path: '', 
      loadChildren: './pages/home/HomeModule#HomeModule' 
    },
    { 
      path: 'ContactUs', 
      loadChildren: './pages/contact-us/ContactUsModule#ContactUsModule' 
    },
    { 
      path: 'About', 
      loadChildren: './pages/about/AboutModule#AboutModule' 
    },
    { 
      path: 'Partner', 
      loadChildren: './pages/partner/PartnerModule#PartnerModule' 
    },
    { 
      path: 'Wallets', 
      loadChildren: './pages/wallets/WalletsModule#WalletsModule' 
    },
    { 
      path: 'faq', 
      loadChildren: './pages/faq/FAQModule#FAQModule' 
    },
  ]),

  // Fallback when no prior route is matched
  { path: '**', redirectTo: '', pathMatch: 'full' }
];

const routerOptions: ExtraOptions = {
  useHash: false,
  anchorScrolling: 'enabled',
  scrollOffset: [60, 90]
};

@NgModule({
  imports: [RouterModule.forRoot(routes, routerOptions)],
  exports: [RouterModule]
})
export class AppRoutingModule { }
