using Neo.SmartContract.Manifest;
using System.Numerics;
using Dvita.SmartContract.Generator.Wrapper;
using Neo.Network.P2P.Payloads;
using Neo;
using Neo.VM.Types;
using Neo.Cryptography.ECC;

namespace Dvita.SmartContract.Wrapper.Interface
{
    public interface IContractABI
    {
        [SafeMethod]
        StackItem Symbol();

        [SafeMethod]
        StackItem Version();

        [SafeMethod]
        StackItem Decimals();

        [SafeMethod]
        StackItem BalanceOf(UInt160 account);
    }

    [GenerateSmartContractAttribute]
    public interface INep17ContractABI : IContractABI
    {
        Transaction Mint(BigInteger amount);
        Transaction Burn(BigInteger amount);
        Transaction Transfer(UInt160 from, UInt160 to, BigInteger amount, object data);
    }

    [GenerateSmartContractAttribute]
    public interface IUpgradableContractABI : IContractABI
    {
        Transaction Upgrade(byte[] nef, ContractManifest manifest);
    }

    [GenerateSmartContractAttribute]
    public interface ICNRContractABI 
    {
        [SafeMethod]
        StackItem Resolve(string cname);
        Transaction Register(string cname, UInt160 address);
        Transaction Unregister(string cname);
    }

    [GenerateSmartContractAttribute]
    public interface IDVTContractABI : IContractABI
    {
        [SafeMethod]
        StackItem GetCandidates();

        [SafeMethod]
        StackItem GetAccountState(UInt160 account);
        Transaction RegisterCandidate(ECPoint pubkey);
        Transaction UnregisterCandidate(ECPoint pubkey);
        Transaction Vote(UInt160 account, ECPoint voteTo);
    }

    [GenerateSmartContractAttribute]
    public interface IManagementContractABI
    {
        Transaction Deploy(byte[] nefFile, string manifest);
    }

    [GenerateSmartContractAttribute]
    public interface ISocialLedgerContractABI
    {
        [SafeMethod]
        StackItem BalanceOf(UInt160 tokenHash, byte[] handle);
        Transaction TransferFromAddressToHandle(UInt160 fromAddress, byte[] handle, UInt160 tokenHash, BigInteger amount);
    }
}
