using Microsoft.CodeAnalysis;
using Microsoft.CodeAnalysis.CSharp.Syntax;

namespace Dvita.SmartContract.Generator.Wrapper
{
    public class AttributeSyntaxReceiver<TAttribute> : ISyntaxReceiver where TAttribute : System.Attribute
    {
        public IList<InterfaceDeclarationSyntax> Interfaces { get; } = new List<InterfaceDeclarationSyntax>();
        public void OnVisitSyntaxNode(SyntaxNode syntaxNode)
        {
            if (syntaxNode is InterfaceDeclarationSyntax classDeclarationSyntax &&
                classDeclarationSyntax.AttributeLists.Count > 0 &&
                classDeclarationSyntax.AttributeLists
                    .Any(al => al.Attributes
                        .Any(a => a.Name.ToString().Equals(typeof(TAttribute).Name))))
            {
                Interfaces.Add(classDeclarationSyntax);
            }
        }
    }
}
