import { Component, OnInit, Renderer2 } from '@angular/core';
import { MatDialog } from '@angular/material/dialog';
import { MessageComponent } from '@app/shared/modals/message/message.component';

@Component({
  selector: 'app-footer',
  templateUrl: './footer.component.html',
  styleUrls: ['./footer.component.scss'],
})
export class FooterComponent implements OnInit {
  constructor(
    private dialog: MatDialog,
    private renderer: Renderer2
  ) {}

  ngOnInit(): void {}

  openUrl(url: string): void {
    const aTag: HTMLInputElement = this.renderer.createElement('a');
    this.renderer.setAttribute(aTag, 'href', url);
    this.renderer.setAttribute(aTag, 'target', '_self');
    aTag.click();
  }
  
  popUpFooterMessage() : void {
    this.dialog.open(MessageComponent, { });
  }
}
