import { AfterViewInit, Component, OnInit, ViewChild } from '@angular/core';
import { MatTableDataSource } from '@angular/material/table';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';
import { Router } from '@angular/router';
import { ExplorerService } from '@app/pages/explorer/explorer.service';

export interface AssetData {
  icon: string;
  name: string;
  type: string;
  blocks: string;
  createdOn: string;
  transactions: string;
}

@Component({
  selector: 'app-contracts-list',
  templateUrl: './contracts-list.component.html',
  styleUrls: ['./contracts-list.component.scss']
})
export class ContractsListComponent implements OnInit, AfterViewInit {
  assetsList!: AssetData[];
  assetsDisplayedColumns: string[] = ['name', 'type', 'blocks', 'createdOn', 'transactions'];
  assetsDataSource!: MatTableDataSource<AssetData>;
  @ViewChild(MatPaginator) paginator!: MatPaginator;
  @ViewChild(MatSort) assetsSort!: MatSort;

  dataLength: number = 0;
  pageSizeOption: number[] = [10, 15, 30, 50];
  pageSize: number = this.pageSizeOption[0];
  pageIndex: number = 1;
  netValues = ['Mainnet', 'TestNet'];
  netValue = this.netValues[0];

  searchValue = '';

  constructor(
    private router: Router,
    private readonly explorerService: ExplorerService
  ) {
  }

  ngOnInit(): void {
    this.assetsList = [
      {
        icon: 'grid',
        name: 'GAS',
        type: 'Utility Token',
        blocks: '7 728 630',
        createdOn: '27.07.2021 | 17:22:06',
        transactions: '567 345',
      },
      {
        icon: 'box',
        name: 'GEO',
        type: 'Governing Token',
        blocks: '7 728 630',
        createdOn: '27.07.2021 | 17:22:06',
        transactions: '567 345',
      },
      {
        icon: 'box',
        name: 'GEO',
        type: 'Governing Token',
        blocks: '7 728 630',
        createdOn: '27.07.2021 | 17:22:06',
        transactions: '567 345',
      },
      {
        icon: 'grid',
        name: 'GAS',
        type: 'Utility Token',
        blocks: '7 728 630',
        createdOn: '27.07.2021 | 17:22:06',
        transactions: '567 345',
      },
      {
        icon: 'home',
        name: 'Effect Al Token',
        type: 'NEP5',
        blocks: '7 728 630',
        createdOn: '27.07.2021 | 17:22:06',
        transactions: '567 345',
      },
      {
        icon: 'home',
        name: 'Effect Al Token',
        type: 'NEP5',
        blocks: '7 728 630',
        createdOn: '27.07.2021 | 17:22:06',
        transactions: '567 345',
      },
      {
        icon: 'home',
        name: 'Effect Al Token',
        type: 'NEP5',
        blocks: '7 728 630',
        createdOn: '27.07.2021 | 17:22:06',
        transactions: '567 345',
      },
      {
        icon: 'home',
        name: 'Effect Al Token',
        type: 'NEP5',
        blocks: '7 728 630',
        createdOn: '27.07.2021 | 17:22:06',
        transactions: '567 345',
      },
      {
        icon: 'home',
        name: 'Effect Al Token',
        type: 'NEP5',
        blocks: '7 728 630',
        createdOn: '27.07.2021 | 17:22:06',
        transactions: '567 345',
      },
      {
        icon: 'home',
        name: 'Effect Al Token',
        type: 'NEP5',
        blocks: '7 728 630',
        createdOn: '27.07.2021 | 17:22:06',
        transactions: '567 345',
      },
      {
        icon: 'home',
        name: 'Effect Al Token',
        type: 'NEP5',
        blocks: '7 728 630',
        createdOn: '27.07.2021 | 17:22:06',
        transactions: '567 345',
      },
      {
        icon: 'home',
        name: 'Effect Al Token',
        type: 'NEP5',
        blocks: '7 728 630',
        createdOn: '27.07.2021 | 17:22:06',
        transactions: '567 345',
      },
      {
        icon: 'home',
        name: 'Effect Al Token',
        type: 'NEP5',
        blocks: '7 728 630',
        createdOn: '27.07.2021 | 17:22:06',
        transactions: '567 345',
      },
      {
        icon: 'home',
        name: 'Effect Al Token',
        type: 'NEP5',
        blocks: '7 728 630',
        createdOn: '27.07.2021 | 17:22:06',
        transactions: '567 345',
      },
      {
        icon: 'home',
        name: 'Effect Al Token',
        type: 'NEP5',
        blocks: '7 728 630',
        createdOn: '27.07.2021 | 17:22:06',
        transactions: '567 345',
      },
    ];
    this.assetsDataSource = new MatTableDataSource(this.assetsList);
    this.dataLength = this.assetsList.length;
    this.assetsDataSource.sort = this.assetsSort;
  }

  ngAfterViewInit(): void {
    this.assetsDataSource.paginator = this.paginator;
    this.assetsDataSource.sort = this.assetsSort;
  }

  makeSearch(): void {
    this.explorerService.search(this.searchValue);
  }

  goContract(row: AssetData): void {
    this.router.navigateByUrl(`/contracts/${row.type}`);
  }

  pageChange(page: any): void {
    this.paginator.pageIndex = page.pageIndex - 1;
    this.paginator.pageSize = page.pageSize;
    this.assetsDataSource.paginator = this.paginator;
  }
}
