import { Injectable } from '@angular/core';
import { WalletProviderDvita } from './wallet-provider-dvita';
import { WalletProviderNeoline } from './wallet-provider-neoline';
import { WalletProviderMetamask } from './wallet-provider-metamask';
import { WalletProvider, WalletProviderName } from './types';

@Injectable({ providedIn: 'root' })
export class WalletPluginService {
    private providers: Record<WalletProviderName, WalletProvider>;

    constructor() {
        this.providers = {
            dvita: new WalletProviderDvita(),
            neoline: new WalletProviderNeoline(),
            metamask: new WalletProviderMetamask(),
        };
    }

    async connectWallet(providerName: WalletProviderName): ReturnType<WalletProvider['connectWallet']> {
        return this.providers[providerName].connectWallet();
    }

    transfer(providerName: WalletProviderName, from: string, to: string, amount: string): ReturnType<WalletProvider['transfer']> {
        return this.providers[providerName].transfer(from, to, amount);
    }

    sign(providerName: WalletProviderName, message: string): ReturnType<WalletProvider['sign']> {
        return this.providers[providerName].sign(message);
    }
}
