export type WalletProviderName = 'dvita' | 'neoline' | 'metamask';

export interface AccountInfo {
    address: string
    label?: string;
}

export interface BalanceInfo {
    icon: string;
    symbol: string;
    amount: string;
}

export interface WalletBalance {
    [address: string]: BalanceInfo;
}

export interface WalletInfo {
    providerName: WalletProviderName;
    account: AccountInfo;
    balance: WalletBalance;
}

export interface WalletProvider {
    connectWallet(): Promise<WalletInfo>;
    transfer(from: string, to: string, amount: string): Promise<string>;
    sign(message: string): Promise<any>;
}
