import { environment } from './../environments/environment';
import { Component, OnInit } from '@angular/core';
import { NavigationEnd, Router } from '@angular/router';
import { Angulartics2GoogleAnalytics } from 'angulartics2/ga';

@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.scss']
})
export class AppComponent implements OnInit {
  title = 'tantails';

  constructor(
    private readonly router: Router,
    public readonly angulartics2GoogleAnalytics: Angulartics2GoogleAnalytics
  ) {
    if (environment.production) {
      this.angulartics2GoogleAnalytics.startTracking();
    }
  }

  ngOnInit(): void {
    this.router.events.subscribe((evt) => {
      if (!(evt instanceof NavigationEnd)) {
        return;
      }

      window.scrollTo(0, 0);
    });
  }
}
