import { task } from 'hardhat/config';
import BigNumber from "bignumber.js";
import { SignerWithAddress } from '@nomiclabs/hardhat-ethers/signers';

task('createToken', 'Create a new token')
	.addParam('nft', 'NFT address')
	.addParam('meta', 'Metadata')
	.addParam('amount', 'Amount of Tokens')
	.setAction(async ({ nft, meta, amount }, { ethers }) => {
		const accounts = await ethers.getSigners();
		const contract = await ethers.getContractAt('TantalisNFT', nft);
		const tokenId = await contract.connect(accounts[0]).createToken(accounts[0].address, meta, amount);

		console.log(`User Address: ${accounts[0].address}`);
		console.log(`Token id: ${tokenId}`);
	});
