import { task } from 'hardhat/config';
import BigNumber from "bignumber.js";
import { SignerWithAddress } from '@nomiclabs/hardhat-ethers/signers';

task('getTerms', 'Get terms and conditions')
	.addParam('nft', 'NFT address')
	.setAction(async ({ nft, meta }, { ethers }) => {
		const contract = await ethers.getContractAt('TantalisNFT', nft);
		const terms = await contract.termsAndConditions();

		console.log(`Terms: ${terms}`);
	});
