import { task } from 'hardhat/config';
import BigNumber from "bignumber.js";
import { SignerWithAddress } from '@nomiclabs/hardhat-ethers/signers';

task('createToken', 'Get balance by address of token and address of user')
	.addParam('nft', 'NFT address')
	.addParam('meta', 'Metadata')
	.setAction(async ({ nft, meta }, { ethers }) => {
		const accounts = await ethers.getSigners();
		const contract = await ethers.getContractAt('TantalisNFT', nft);
		const tokenId = await contract.connect(accounts[0]).createToken(accounts[0].address, meta);

		console.log(`User Address: ${accounts[0].address}`);
		console.log(`Token id: ${tokenId}`);
	});
