import { TantalisNFT } from '../typechain';
import { ethers, upgrades, network, run } from 'hardhat';
import {delay} from '../utils';

import {
	hashBytecodeWithoutMetadata,
	Manifest,
} from "@openzeppelin/upgrades-core";

async function deployTantalisNFT() {
	const NFTName = 'TantalisNFT';
	const NFTSymbol = 'CNFT';
	
	console.log('starting deploying nft...');
	
	const TantalisNFT = await ethers.getContractFactory('TantalisNFT');
	console.log('starting deploying nft...');
	const nft = await upgrades.deployProxy(TantalisNFT, [NFTName, NFTSymbol, "0x0000000000000000000000000000000000000000", [], []]) as TantalisNFT;
	
	console.log('TantalisNFT proxy deployed with address: ' + nft.address);

	await nft.deployed();

	const ozUpgradesManifestClient = await Manifest.forNetwork(network.provider);
	const manifest = await ozUpgradesManifestClient.read();
	const bytecodeHash = hashBytecodeWithoutMetadata(TantalisNFT.bytecode);
	const TantalisImplementation = manifest.impls[bytecodeHash];

	console.log('TantalisNFT implementation deployed with address: ' + TantalisImplementation!.address);

	// if(network.name != 'localhost') {
	// 	console.log('delay...');
	
	// 	await delay(20);

	// 	console.log('Starting implementation verification...');

	// 	try {
	// 		await run('verify:verify', {
	// 			address: TantalisImplementation!.address,
	// 			constructorArguments: [],
	// 		});
	// 		console.log('verify success');
	// 	} catch (e: any) {
	// 		console.log(e.message);
	// 	}
	// }
}

deployTantalisNFT()
.then(() => process.exit(0))
.catch(error => {
	console.error(error);
	process.exit(1);
});
