import { task } from 'hardhat/config'
import BigNumber from "bignumber.js"
import { SignerWithAddress } from '@nomiclabs/hardhat-ethers/signers';
import { solidityKeccak256, arrayify } from "ethers/lib/utils";


task('setRoyalty', 'set NFT default royalty')
	.addParam('percent', 'Price of the NFT')
	.addParam('token', 'Address of the token')
	.setAction(async ({ percent, token }, { ethers }) => {
		const accounts = await ethers.getSigners();
		const nft = await ethers.getContractAt('TestNFT', token);

		await nft.setDefaultRoyalty(accounts[1].address, percent);
		// await contract.connect(accounts[0]).buy(seller, buyer, token, tokenid, price, signature);
		const royaltyInfo = await nft.royaltyInfo(ethers.BigNumber.from(0), ethers.BigNumber.from(10000000000000));
		console.log(royaltyInfo[1]);
		console.log(`Success`);
	})
