import { task } from 'hardhat/config'
import BigNumber from "bignumber.js"
import { SignerWithAddress } from '@nomiclabs/hardhat-ethers/signers';

task('exportNFT', 'Export NFT called by executor')
	.addParam('nonce', 'Nonce of the message')
	.addParam('tokenId', 'Id of the token')
	.addParam('token', 'Address of the token')
	.addParam('reciever', 'Reciever address')
	.addParam('sender', 'Sender address')
	.addParam('signature', 'Validator signature')
	.setAction(async ({ nonce, tokenId, token, reciever, sender, signature }, { ethers }) => {
		const accounts = await ethers.getSigners();
		const contract = await ethers.getContractAt('Marketplace', token);
		await contract.connect(accounts[0]).buy(sender, reciever, token, tokenId, nonce, signature);

		console.log(`Success`);
	})
