import { task } from 'hardhat/config'
import { SignerWithAddress } from '@nomiclabs/hardhat-ethers/signers';
import { solidityKeccak256, arrayify } from "ethers/lib/utils";


task('buy', 'Buying of NFT called by executor')
	.addParam('price', 'Price of the NFT')
	.addParam('tokenid', 'Id of the token')
	.addParam('token', 'Address of the token')
	.addParam('market', 'Address of the market')
	.addParam('buyer', 'Buyer address')
	.addParam('seller', 'Seller address')
	.setAction(async ({ price, tokenid, token, market, buyer, seller }, { ethers }) => {
		const accounts = await ethers.getSigners();
		const contract = await ethers.getContractAt('Marketplace', market);
		
		// const ex = await contract.EXECUTOR_ROLE();
		// const val = await contract.VALIDATOR_ROLE();

		// await contract.grantRole(ex, accounts[0].address);
		// await contract.grantRole(val, accounts[0].address);

		// console.log( ex+" executor " + await contract.hasRole(solidityKeccak256(["string"], ["EXECUTOR_ROLE"]), accounts[0].address));
		// console.log(val + " validator " + await contract.hasRole(solidityKeccak256(["string"], ["VALIDATOR_ROLE"]), accounts[0].address));

		const nft = await ethers.getContractAt('TestNFT', token);
		const message = arrayify(
			solidityKeccak256( 
				["address", "address", "address", "address", "uint256", "uint256"], 
				[seller, seller, buyer, token, tokenid, price]
			)
		);

		const royaltyInfo = await nft.royaltyInfo(tokenid, price);
		console.log(royaltyInfo[1]);
		const signature = await accounts[0].signMessage(message);
		await contract.connect(accounts[0]).buy(seller, buyer, token, tokenid, price, signature, {value: royaltyInfo[1]});

		console.log(`Success`);
	})