import { TestNFT } from '../typechain';
import { ethers, upgrades, network, run } from 'hardhat';
import {delay} from '../utils';

import {
	hashBytecodeWithoutMetadata,
	Manifest,
} from "@openzeppelin/upgrades-core";

async function deployTantalisNFT() {
	const NFTName = 'TestNFT';
	const NFTSymbol = 'TNFT';
	
	console.log('starting deploying nft...');
	
	const TestNFT = await ethers.getContractFactory('TestNFT');
	console.log('starting deploying nft...');
	const accounts = await ethers.getSigners();
	const nft = await upgrades.deployProxy(TestNFT, [NFTName, NFTSymbol, "0xb203d28c555D8cc9985f28d592fA5DDFfD50EF15", [accounts[0].address], ['https://example.com']]) as TestNFT;
	
	console.log('TantalisNFT proxy deployed with address: ' + nft.address);

	await nft.deployed();

	const ozUpgradesManifestClient = await Manifest.forNetwork(network.provider);
	const manifest = await ozUpgradesManifestClient.read();
	const bytecodeHash = hashBytecodeWithoutMetadata(TestNFT.bytecode);
	const TantalisImplementation = manifest.impls[bytecodeHash];

	console.log('TantalisNFT implementation deployed with address: ' + TantalisImplementation!.address);

	if(network.name != 'localhost') {
		console.log('delay...');
	
		await delay(20);

		console.log('Starting implementation verification...');

		try {
			await run('verify:verify', {
				address: TantalisImplementation!.address,
				constructorArguments: [],
			});
			console.log('verify success');
		} catch (e: any) {
			console.log(e.message);
		}
	}
}

deployTantalisNFT()
.then(() => process.exit(0))
.catch(error => {
	console.error(error);
	process.exit(1);
});
