import { Marketplace } from '../typechain';
import { ethers, upgrades, network, run } from 'hardhat';
import { delay } from '../utils';

import {
	hashBytecodeWithoutMetadata,
	Manifest,
} from "@openzeppelin/upgrades-core";

async function deployMarketplace() {
	// ToDo: change to valid addresses
	const validator = ethers.constants.AddressZero;
	const executor = ethers.constants.AddressZero;
	
	const Marketplace = await ethers.getContractFactory('Marketplace');
	console.log('starting deploying marketplace...');
	const marketplace = await upgrades.deployProxy(Marketplace, [validator, executor]) as Marketplace;
	
	console.log('Marketplace proxy deployed with address: ' + marketplace.address);

	await marketplace.deployed();

	const ozUpgradesManifestClient = await Manifest.forNetwork(network.provider);
	const manifest = await ozUpgradesManifestClient.read();
	const bytecodeHash = hashBytecodeWithoutMetadata(Marketplace.bytecode);
	const TantalisImplementation = manifest.impls[bytecodeHash];

	console.log('Marketplace implementation deployed with address: ' + TantalisImplementation!.address);
	if(network.name != 'localhost') {
		console.log('delay...');
	
		await delay(20);

		console.log('Starting implementation verification...');

		try {
			await run('verify:verify', {
				address: marketplace!.address,
				contract: 'contracts/Marketplace.sol:Marketplace',
				constructorArguments: [],
			});
			console.log('verify success');
		} catch (e: any) {
			console.log(e.message);
		}
	}
}

deployMarketplace()
.then(() => process.exit(0))
.catch(error => {
	console.error(error);
	process.exit(1);
});
