# Marketplace contract

## Deployed addresses:

### BSC testnet

Marketplace proxy deployed with address: 0xb203d28c555D8cc9985f28d592fA5DDFfD50EF15

Marketplace implementation deployed with address: 0x1E1f5bCA5680D61Ba5806Ae05438c35D0E5f0c0e

TestNFT proxy deployed with address: 0x48790f7629c891Cf4E5EA26Ce7c2962742B3FbE2

TestNFT implementation deployed with address: 0xDD8c86e632Fc939c8586a42592f844eCBDF86062

### Install

Clone `npm install`, then compile contracts with `npm run compile`.

### Run Contract Tests & Get Callstacks

`npm run test`

### Run Coverage Report for Tests

`npm run coverage`

### Deploy example

Script to deploy CustomToken in rinkeby.

_create .env-rinkeby before._

`npx hardhat run --network rinkeby scripts/deployMarketplace.ts`

### Task example

`npx hardhat buy --network rinkeby --token TOKEN_ADDRESS --seller SELLER_ADDRESS...`

`npx hardhat buy --network localhost --token TOKEN_ADDRESS --price PRICE --tokenid TOKEN_ID --market MARKET --seller SELLER_ADDRESS --buyer BUYER_ADDRESS`

### Verification example

`npx hardhat verify --network rinkeby CONTRACT_ADDRESS ARG1 ARG2`

To verify upgradable contract - you need use address of implementation as `CONTRACT_ADDRESS`
