DVITA social ledger smart contract
==================================

Deployment
----------

    open wallet /nxa-node-data/hot.json

    deploy /nef.bin /manifest.json
        Contract hash: 0x78d31736ce09ac7c5274341947b9d706d64b1fac
        Gas consumed: 10.0276393
        Network fee: 0.0759952
        Total fee: 10.1036345 GAS
        Relay tx? (no|yes): y
        Signed and relayed transaction with hash:
        0x52130fd7c598b108a28c364e8dbd48779a0c9f08eeea7ae7ff80df12a34d9492

    update 0x78d31736ce09ac7c5274341947b9d706d64b1fac /nef.bin /manifest.json NZJsKhsKzi9ipzjC57zU53EVMC97zqPDKG NZJsKhsKzi9ipzjC57zU53EVMC97zqPDKG {"type":"Any","value":null} 

    Contract hash: 0x78d31736ce09ac7c5274341947b9d706d64b1fac
    
Interactions
------------

    // balanceOf('@cnn', 'dvg');
    // where 'dvg' -> '0xd2a4cff31913016155e38e474a2c06d08be276cf' -> 'NepwUjd9GhqgNkrfXaxj9mmsFhFzGoFuWM' -> 'z3bii9AGLEpHjuNVYQETGfPPpNI='

    invoke 0x78d31736ce09ac7c5274341947b9d706d64b1fac balanceOf [{"type":"ByteArray","value":"QGNubg=="},{"type":"ByteArray","value":"z3bii9AGLEpHjuNVYQETGfPPpNI="}]

    // balanceOf('@fancy_uyx', 'dvg');
    invoke 0x78d31736ce09ac7c5274341947b9d706d64b1fac balanceOf [{"type":"ByteArray","value":"QGZhbmN5X3V5eA=="},{"type":"ByteArray","value":"z3bii9AGLEpHjuNVYQETGfPPpNI="}]

    // transferFromAddressToHandle('NZJsKhsKzi9ipzjC57zU53EVMC97zqPDKG', '@cnn', 'dvg', 1)
    invoke 0x78d31736ce09ac7c5274341947b9d706d64b1fac transferFromAddressToHandle [{"type":"ByteArray","value":"ku5O5IVJRg4eLYfZSxhnZdU47U0="},{"type":"ByteArray","value":"QGNubg=="},{"type":"ByteArray","value":"z3bii9AGLEpHjuNVYQETGfPPpNI="},{"type":"Integer","value":"1"}] NZJsKhsKzi9ipzjC57zU53EVMC97zqPDKG NZJsKhsKzi9ipzjC57zU53EVMC97zqPDKG

    // transferFromAddressToHandle('NZJsKhsKzi9ipzjC57zU53EVMC97zqPDKG', '@fancy_uyx', 'dvg', 3)
    invoke 0x78d31736ce09ac7c5274341947b9d706d64b1fac transferFromAddressToHandle [{"type":"ByteArray","value":"ku5O5IVJRg4eLYfZSxhnZdU47U0="},{"type":"ByteArray","value":"QGZhbmN5X3V5eA=="},{"type":"ByteArray","value":"z3bii9AGLEpHjuNVYQETGfPPpNI="},{"type":"Integer","value":"3"}] NZJsKhsKzi9ipzjC57zU53EVMC97zqPDKG NZJsKhsKzi9ipzjC57zU53EVMC97zqPDKG

    // claimAllToAddress('@cnn', 'NZJsKhsKzi9ipzjC57zU53EVMC97zqPDKG', 'NZJsKhsKzi9ipzjC57zU53EVMC97zqPDKG')
    invoke 0x78d31736ce09ac7c5274341947b9d706d64b1fac claimAllToAddress [{"type":"ByteArray","value":"QGNubg=="},{"type":"ByteArray","value":"ku5O5IVJRg4eLYfZSxhnZdU47U0="},{"type":"ByteArray","value":"ku5O5IVJRg4eLYfZSxhnZdU47U0="}] NZJsKhsKzi9ipzjC57zU53EVMC97zqPDKG

    // claimAllToAddress('@fancy_uyx', 'NZJsKhsKzi9ipzjC57zU53EVMC97zqPDKG', 'NZJsKhsKzi9ipzjC57zU53EVMC97zqPDKG')
    invoke 0x78d31736ce09ac7c5274341947b9d706d64b1fac claimAllToAddress [{"type":"ByteArray","value":"QGZhbmN5X3V5eA=="},{"type":"ByteArray","value":"ku5O5IVJRg4eLYfZSxhnZdU47U0="},{"type":"ByteArray","value":"ku5O5IVJRg4eLYfZSxhnZdU47U0="}] NZJsKhsKzi9ipzjC57zU53EVMC97zqPDKG

    // claimAllToAddress('@NASA', 'NZJsKhsKzi9ipzjC57zU53EVMC97zqPDKG', 'NZJsKhsKzi9ipzjC57zU53EVMC97zqPDKG')
    invoke 0x78d31736ce09ac7c5274341947b9d706d64b1fac claimAllToAddress [{"type":"ByteArray","value":"QE5BU0E="},{"type":"ByteArray","value":"ku5O5IVJRg4eLYfZSxhnZdU47U0="},{"type":"ByteArray","value":"ku5O5IVJRg4eLYfZSxhnZdU47U0="}] NZJsKhsKzi9ipzjC57zU53EVMC97zqPDKG

    552016/552016
        Ng1F3oJWguiuKWrdMf4qm1v8GEg3S5zMxD
        DVITA: 0
        DVG:   0

        NZJsKhsKzi9ipzjC57zU53EVMC97zqPDKG
        DVITA: 31
        DVG:   3030.41105533

        NXZhQdDF6mNLHAspW2YF6SANYNJfnwaP2k
        DVITA: 999900000
        DVG:   51998539.7119664


    // balanceOfh(token, address)
    balanceOfh dvg @cnn

    // transfera2h(tokenHash, handle, amount, from, sender, signerAccounts)
    transfera2h dvg @cnn 100000000 NZJsKhsKzi9ipzjC57zU53EVMC97zqPDKG NZJsKhsKzi9ipzjC57zU53EVMC97zqPDKG 

    balanceOfh dvg @NASA
    transfera2h dvg @NASA 100000000 NZJsKhsKzi9ipzjC57zU53EVMC97zqPDKG NZJsKhsKzi9ipzjC57zU53EVMC97zqPDKG 

    balanceof(UInt160 tokenHash, UInt160 address)
    transfera2h(UInt160 tokenHash, string handle, decimal amount, UInt160 from, UInt160 sender = null, UInt160[] signerAccounts = null)

    {"jsonrpc": "2.0","method": "getnep17balances","params":["NgaiKFjurmNmiRzDRQGs44yzByXuSkdGPF"],"id": 1}

