// using Neo.SmartContract.Framework.Attributes;
using System;
using System.ComponentModel;
using System.Numerics;

using Neo;
using Neo.SmartContract.Framework;
using Neo.SmartContract.Framework.Native;
using Neo.SmartContract.Framework.Services;

namespace Dvita.SmartContracts
{
    public abstract class TokenContract : SmartContract
    {
        protected const byte Prefix_TotalSupply = 0x00;
        protected const byte Prefix_Balance = 0x01;

        [Safe]
        public abstract string Symbol();

        [Safe]
        public abstract byte Decimals();

        [Safe]
        public static BigInteger TotalSupply() => (BigInteger)Storage.Get(Storage.CurrentContext, new byte[] { Prefix_TotalSupply });

        [Safe]
        public virtual BigInteger BalanceOf(UInt160 owner)
        {
            if (owner is null || !owner.IsValid)
            {
                throw new Exception("The argument \"owner\" is invalid.");
            }

            StorageMap balanceMap = new(Storage.CurrentContext, Prefix_Balance);
            
            return (BigInteger)balanceMap[owner];
        }

        protected virtual void UpdateTotalSupply(BigInteger increment)
        {
            StorageContext context = Storage.CurrentContext;
            byte[] key = new byte[] { Prefix_TotalSupply };
            BigInteger totalSupply = (BigInteger)Storage.Get(context, key);
            totalSupply += increment;
            Storage.Put(context, key, totalSupply);
        }

        protected virtual bool UpdateBalance(UInt160 owner, BigInteger increment)
        {
            StorageMap balanceMap = new(Storage.CurrentContext, Prefix_Balance);
            BigInteger balance = (BigInteger)balanceMap[owner];
            balance += increment;
            
            if (balance < 0) 
            {
                return false;
            }
            
            if (balance.IsZero)
            {
                balanceMap.Delete(owner);
            }
            else
            {
                balanceMap.Put(owner, balance);
            }
            
            return true;
        }
    }
}