>  DEP: 721   
>  Title: Non-Fungible Token Standard  
>  Authors: XXX
> Type: Standard  
> Date: 2022-06-06

<h2>Abstract</h2>

This DEP defines a standard non-fungible token system for the Dvita Smart Economy.

<h2>Motivation</h2>

#Need to change and add smth like extended from EIP-721, EIP-2981 and NEP-11
NFTs are required to track, exchange and enforce ownership of digital assets.
A non-fungible token (NFT) can be thought of like a property deed - each one is unique and carries some non-mutable information (e.g. the physical address of the property).
Other information, such as the owner of the property, can be changed.
Also, we provide built-in optional divisibility within each non-fungible asset.
This allows for high value objects to be tokenized more effectively.

<h2>Specification</h2>
<h3>Common methods</h3>
<h4>symbol</h4>


    {
      "name": "symbol",
      "safe": true,
      "parameters": [],
      "returntype": "String"
    }

#ToDo change it
Returns a short string symbol of the token managed in this contract. e.g. <code>"MNFT"</code>.
This symbol SHOULD be short (3-8 characters is recommended), with no whitespace characters or new-lines and SHOULD be limited to the uppercase latin alphabet (i.e. the 26 letters used in English).

This method MUST always return the same value every time it is invoked.

<h4>decimals</h4>


    {
      "name": "decimals",
      "safe": true,
      "parameters": [],
      "returntype": "Integer"
    }

#Todo change it
Returns the number of decimals used by the token - e.g. <code>8</code>, means to divide the token amount by <code>100,000,000</code> to get its user representation.

If the token managed in this contract is indivisible, the function SHOULD return <code>0</code>.

If this method returns <code>0</code>, the "Non-divisible NFT methods" must be implemented.
Otherwise, the "Divisible NFT methods" must be implemented.

This method MUST always return the same value every time it is invoked.

<h4>totalSupply</h4>


    {
      "name": "totalSupply",
      "safe": true,
      "parameters": [],
      "returntype": "Integer"
    }


Returns the total token supply currently in the system.

<h4>tokensOf</h4>


    {
      "name": "tokensOf",
      "safe": true,
      "parameters": [
        {
          "name": "owner",
          "type": "Hash160"
        }
      ],
      "returntype": "InteropInterface<iterator>"
    }


Returns an <code>iterator</code> that contains all of the token ids owned by the specified address.
Each of these IDs SHOULD be a ByteString with a length of no more than 64 bytes.

The parameter <code>owner</code> SHOULD be a 20-byte address.
If not, this method SHOULD <code>throw</code> an exception.

<h4>transfer</h4>

    {
      "name": "transfer",
      "safe": false,
      "parameters": [
        {
          "name": "to",
          "type": "Hash160"
        },
        {
          "name": "tokenId",
          "type": "ByteString"
        },
        {
          "name": "data",
          "type": "Any"
        }
      ],
      "returntype": "Boolean"
    }

It transfers the token with id <code>tokenId</code> to address <code>to</code>.

The parameter <code>to</code> SHOULD be a 20-byte address.
If not, this method SHOULD <code>throw</code> an exception.

The parameter <code>tokenId</code> SHOULD be a valid NFT ID (64 or less bytes long).
If not, this method SHOULD <code>throw</code> an exception.

The function SHOULD return <code>false</code> if the token that will be transferred has more than one owner.

If the method succeeds, it MUST fire the <code>Transfer</code> event, and MUST return <code>true</code>, even if the token is sent to the owner.

If the receiver is a deployed contract, the function MUST call <code>onNEP11Payment</code> method on receiver contract with the <code>data</code> parameter from <code>transfer</code> AFTER firing the <code>Transfer</code> event.

The function SHOULD check whether the owner address equals the caller contract hash.
If so, the transfer SHOULD be processed; If not, the function SHOULD use the SYSCALL <code>Neo.Runtime.CheckWitness</code> to verify the transfer.

If the transfer is not processed, the function SHOULD return <code>false</code>.

<h4>transferFrom</h4>

    {
      "name": "transferFrom",
      "safe": false,
      "parameters": [
        {
          "name": "from",
          "type": "Hash160"
        },
        {
          "name": "to",
          "type": "Hash160"
        },
        {
          "name": "tokenId",
          "type": "ByteString"
        },
        {
          "name": "data",
          "type": "Any"
        }
      ],
      "returntype": "Boolean"
    }

Transfer ownership of an NFT -- THE CALLER IS RESPONSIBLE TO CONFIRM THAT `to` IS CAPABLE OF RECEIVING NFTS OR ELSE THEY MAY BE PERMANENTLY LOST

<h4>approve</h4>

    {
      "name": "approve",
      "safe": false,
      "parameters": [
        {
          "name": "operator",
          "type": "Hash160"
        },
        {
          "name": "tokenId",
          "type": "ByteString"
        }
      ],
      "returntype": "Void"
    }

Change or reaffirm the operator address for an NFT

<h4>setApprovalForAll</h4>

    {
      "name": "setApprovalForAll",
      "safe": false,
      "parameters": [
        {
          "name": "operator",
          "type": "Hash160"
        },
        {
          "name": "approved",
          "type": "Boolean"
        }
      ],
      "returntype": "Void"
    }

Enable or disable approval for a third party ("operator") to manage all of caller's(tx Sender) assets

<h4>getApproved</h4>

    {
      "name": "getApproved",
      "safe": true,
      "parameters": [
        {
          "name": "tokenId",
          "type": "ByteString"
        }
      ],
      "returntype": "Hash160"
    }

Get the approved address for a single NFT

<h4>isApprovedForAll</h4>

    {
      "name": "isApprovedForAll",
      "safe": true,
      "parameters": [
        {
          "name": "owner",
          "type": "Hash160"
        },
        {
          "name": "operator",
          "type": "Hash160"
        }
      ],
      "returntype": "Boolean"
    }

Get the approved address for a single NFT

<h4>ownerOf</h4>

    {
      "name": "ownerOf",
      "safe": true,
      "parameters": [
        {
          "name": "tokenId",
          "type": "ByteString"
        }
        
      ],
      "returntype": "Hash160"
    }

Returns the owner of the specified token.

The parameter <code>tokenId</code> SHOULD be a valid NFT ID (64 or less bytes long).
If not, this method SHOULD <code>throw</code> an exception.

<h4>balanceOf</h4>

    {
      "name": "balanceOf",
      "safe": true,
      "parameters": [
        {
          "name": "owner",
          "type": "Hash160"
        },
        {
          "name": "tokenId",
          "type": "ByteString"
        }
      ],
      "returntype": "Integer"
    }

This method returns the balance of the specified token for the specified <code>owner</code>'s account.

The parameter <code>tokenId</code> SHOULD be a valid NFT ID (64 or less bytes long).
If not, this method SHOULD <code>throw</code> an exception.

The parameter <code>owner</code> SHOULD be a 20-byte address.
If not, this method SHOULD <code>throw</code> an exception.

If the <code>owner</code> is an unused address, or it's not the owner of the specified token, this method SHOULD return <code>0</code>.

<h3>Optional methods</h3>

<h4>tokens</h4>

    {
      "name": "tokens",
      "safe": true,
      "parameters": [],
      "returntype": "InteropInterface<iterator>"
    }

Returns an <code>iterator</code> that contains all of the tokens minted by the contract.

<h4>properties</h4>

    {
      "name": "properties",
      "safe": true,
      "parameters": [
        {
          "name": "tokenId",
          "type": "ByteString"
        }
      ],
      "returntype": "Map"
    }

Returns a serialized NVM object containing the properties for the given NFT.
The NVM object must conform to the "NEO NFT Metadata JSON Schema".

The parameter <code>tokenId</code> SHOULD be a valid NFT ID (64 or less bytes long).
If not, this method SHOULD <code>throw</code> an exception.

Following is a description of the JSON Schema:

    {
      "title": "Asset Metadata",
      "type": "object",
      "required": ["name"],
      "properties": {
        "name": {
          "type": "string",
          "description": "Identifies the asset to which this NFT represents."
        },
        "description": {
          "type": "string",
          "description": "Optional. Describes the asset to which this NFT represents."
        },
        "image": {
          "type": "string",
          "format": "uri",
          "description": "Optional. A URI pointing to a resource with mime type image/* representing the asset to which this NFT represents. Consider making any images at a width between 320 and 1080 pixels and aspect ratio between 1.91:1 and 4:5 inclusive."
        },
        "tokenURI": {
          "type": "string",
          "format": "uri",
          "description": "Optional. A distinct URI for a given asset that adheres to RFC 3986"
        }
      }
    }

Given this schema, the simplest json object that can be constructed is the following:

    {
       "name": "Slime 1"
    }

And if all the properties are included:

    {
       "name": "Slime 2",
       "description": "A slime",
       "image": "{some image URI}",
       "tokenURI": "{some URI}"
    }


<h3>Receiver methods</h3>

<h4>onNEP11Payment<h4>

    {
      "name": "onNEP11Payment",
      "parameters": [
        {
          "name": "from",
          "type": "Hash160"
        },
        {
          "name": "amount",
          "type": "Integer"
        },
        {
          "name": "tokenId",
          "type": "ByteString"
        },
        {
          "name": "data",
          "type": "Any"
        }
      ],
      "returntype": "Void"
    }

If a contract is to receive NFTs, it must implement the receiver method. Transferring NFTs to any contract that does not implement the receiver method will cause the transaction to fail. If the receiver doesn't want to receive this transfer it MUST abort the execution.

The meaning of the parameters of the <code>onNEP11Payment</code> method is consistent with that of <code>transfer</code>. 

<h3>Events</h3>
<h4>Approval</h4>

    {
      "name": "Approval",
      "parameters": [
        {
          "name": "owner",
          "type": "Hash160"
        },
        {
          "name": "operator",
          "type": "Hash160"
        },
        {
          "name": "tokenId",
          "type": "ByteString"
        }
      ]
    }

This emits when the operator address for an NFT is changed or reaffirmed. The zero address indicates there is no operator address. When a Transfer event emits, this also indicates that the operator address for that NFT (if any) is reset to none.

<h4>ApprovalForAll</h4>

    {
      "name": "Approval",
      "parameters": [
        {
          "name": "owner",
          "type": "Hash160"
        },
        {
          "name": "operator",
          "type": "Hash160"
        },
        {
          "name": "approved",
          "type": "Boolean"
        }
      ]
    }

This emits when an operator is enabled or disabled for an owner. The operator can manage all NFTs of the owner.

<h4>Transfer</h4>

    {
      "name": "Transfer",
      "parameters": [
        {
          "name": "from",
          "type": "Hash160"
        },
        {
          "name": "to",
          "type": "Hash160"
        },
        {
          "name": "tokenId",
          "type": "ByteString"
        }
      ]
    }

MUST trigger when tokens are transferred, including zero value transfers.

A token contract which creates new tokens MUST trigger a <code>Transfer</code> event with the <code>from</code> address set to <code>null</code> when tokens are created.

A token contract which burns tokens MUST trigger a <code>Transfer</code> event with the <code>to</code> address set to <code>null</code> when tokens are burned.

<h2>Implementation</h2>

Coming soon...