import { wallet, u } from '@cityofzion/neon-core';
import { SignedPayload } from '@/auth/dto/signed-payload.dto';

export function verifySignature(address: string, signedPayload: SignedPayload) {
  // verify address
  const signerAddress = wallet.getAddressFromScriptHash(wallet.getScriptHashFromPublicKey(signedPayload.publicKey));
  if (signerAddress !== address) {
    throw new Error('Address does not match signer address');
  }

  // verify signature
  const payload = typeof signedPayload.payload === 'object'
    ? JSON.stringify(signedPayload.payload)
    : signedPayload.payload;
  const isValidSignature = wallet.verify(
    u.str2hexstring(signedPayload.salt + payload),
    signedPayload.signature,
    signedPayload.publicKey,
  )
  if (!isValidSignature) {
    throw new Error('Invalid signature');
  }
}
