import { Module } from '@nestjs/common';
import { UserInfoController } from './user-info.controller';
import { UserInfoService } from './user-info.service';
import { TypeOrmModule } from '@nestjs/typeorm';
import { UserInfoEntity } from './entities/user-info.entity';
import { OpenApiModule } from '@/openapi/openapi.module';
import { TwitterInfoEntity } from '@/social-auth/entities/twitter-info.entity';

@Module({
  imports: [
    TypeOrmModule.forFeature([UserInfoEntity]),
    TypeOrmModule.forFeature([TwitterInfoEntity]),
    OpenApiModule
  ],
  controllers: [UserInfoController],
  providers: [UserInfoService],
})
export class UserInfoModule {}
