import { Entity, Column, PrimaryColumn, CreateDateColumn, UpdateDateColumn } from 'typeorm';

@Entity()
export class UserInfoEntity {
    @PrimaryColumn()
    address: string;

    @Column()
    name: string;

    @Column()
    surname: string;

    @Column()
    email: string;

    @Column()
    avatar: string;

    @Column({nullable: true})
    dvitaId?: string;

    @Column({nullable: true})
    twitter?: string;

    @CreateDateColumn()
    createdDate: Date;

    @UpdateDateColumn()
    modifiedDate: Date;
}
