import { HttpService } from "@nestjs/axios";
import { Injectable, Logger } from "@nestjs/common";
import { lastValueFrom } from "rxjs";


export interface AwardUserResultDto {
    dvtTxHash: string;
    dvgTxHash: string;
    dvt: string;
    dvg: string;
}

@Injectable()
export class SocialRewardsService {

    constructor(
        private readonly httpService: HttpService
    ) {
        this.logger.debug('Using:', SocialRewardsService.socialRewardsApiEndpoint);
    }

    private readonly logger = new Logger(SocialRewardsService.name);
    private static readonly authToken = process.env.SOCIALREWARDSAPI_AUTH_TOKEN!;
    private static readonly socialRewardsApiEndpoint = process.env.SOCIALREWARDSAPI_ENDPOINT!;

    async awardUser(
        socialNetwork: string,
        address: string,
        userId: string,
        userSocialHandle: string,
        accessToken: string
    ): Promise<AwardUserResultDto> {
        const headersRequest = {
            'Authorization': SocialRewardsService.authToken,
        };
        const response = await lastValueFrom(
            this.httpService.post<AwardUserResultDto>(`${SocialRewardsService.socialRewardsApiEndpoint}/api/welcome/reward`, {
                address,
                userId,
                userSocialHandle,
                accessToken,
                socialNetwork
            },
            { headers: headersRequest })
        );
        return response.data;
    }
}