import { Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { SocialAuthController } from './social.auth.controller';
import { AuthTwitterService } from './twitter.social.auth.service';
import { TwitterInfoEntity } from './entities/twitter-info.entity';
import { UserInfoEntity } from '@/user-info/entities/user-info.entity';
import { OpenApiModule } from '@/openapi/openapi.module';
import { SocialRewardsModule } from '../social-rewards/social.rewards.module';

@Module({
    imports: [
        TypeOrmModule.forFeature([UserInfoEntity]),
        TypeOrmModule.forFeature([TwitterInfoEntity]),
        OpenApiModule,
        SocialRewardsModule
    ],
    controllers: [SocialAuthController],
    providers: [AuthTwitterService]
})
export class SocialAuthModule {}
