import { UseGuards, Controller, Get, Req, Res } from '@nestjs/common';
import { ApiBearerAuth, ApiTags } from '@nestjs/swagger';
import { AuthGuard, getAuthTokenSigner } from '../auth/auth.guard';
import { AuthTwitterService } from './twitter.social.auth.service';
import { Request, Response } from 'express';

@ApiBearerAuth()
@ApiTags('social/auth')
@Controller('social/auth')
export class SocialAuthController {
    constructor(private readonly authTwitterService: AuthTwitterService) { }

  @UseGuards(AuthGuard)
  @Get('twitter/authurl')
  async getTwitterAuthUrl(@Req() req: Request): Promise<string> {
      const signerAddress = getAuthTokenSigner(req);
      return await this.authTwitterService.createAuthUrl(req, signerAddress)
  }

  @Get('twitter/callback')
  async getTwitterAuthCallback(@Req() req: Request, @Res() res: Response): Promise<void> {
      await this.authTwitterService.twitterAuthCallback(req, res);
  }

  @UseGuards(AuthGuard)
  @Get('twitter/username')
  async getTwitterUsername(@Req() req: Request): Promise<any> {
      const signerAddress = getAuthTokenSigner(req);
      return await this.authTwitterService.getTwitterUsername(signerAddress);
  }
}
