import { Entity, Column, PrimaryColumn, UpdateDateColumn, CreateDateColumn } from 'typeorm';

@Entity()
export class TwitterInfoEntity {
    @PrimaryColumn()
    address: string;

    @Column()
    twitterUserName: string;

    @Column()
    twitterUserId: string;

    @Column({ nullable: true })
    accessToken?: string;

    @Column({ nullable: true })
    refreshToken?: string;

    @Column({ nullable: true })
    expiresIn: number;

    @CreateDateColumn()
    createdDate: Date;

    @UpdateDateColumn()
    modifiedDate: Date;
}
