import { Injectable, Logger } from "@nestjs/common";
import { InjectRepository } from "@nestjs/typeorm";
import { Repository } from "typeorm";
import { RegisterProjectDto } from "./dto/register-project.dto";
import { RegisterProjectEntity } from "./entities/register-project.entity";

@Injectable()
export class RegisterProjectService {
  private readonly logger = new Logger(RegisterProjectService.name);

  constructor(
    @InjectRepository(RegisterProjectEntity)
    private readonly registerProjectRepository: Repository<RegisterProjectEntity>
  ) {}

  async create(registerProjectDto: RegisterProjectDto): Promise<RegisterProjectEntity>  {
    this.logger.debug(`Creating: ${JSON.stringify(registerProjectDto)}`)
    const registerProjectInfo: RegisterProjectEntity = this.registerProjectRepository.create({
      address: registerProjectDto.address,
      email: registerProjectDto.email,
      message: registerProjectDto.message,
      title: registerProjectDto.title
    });

    const saved = await this.registerProjectRepository.save(registerProjectInfo);
    return saved;
  }
}