import { Body, Controller, Post } from '@nestjs/common';
import {
  ApiBearerAuth,
  ApiOperation,
  ApiResponse,
  ApiTags
} from '@nestjs/swagger';
import { RegisterProjectEntity } from './entities/register-project.entity';
import { RegisterProjectService } from './register-project.service';
import { RegisterProjectDto } from './dto/register-project.dto';

@ApiBearerAuth()
@ApiTags('register-project')
@Controller('register-project')
export class RegisterProjectController {
  constructor(private readonly registerProjectService: RegisterProjectService) {}
  
  @Post()
  @ApiOperation({ summary: 'Register your dVITA project' })
  @ApiResponse({ status: 403, description: 'Forbidden' })
  @ApiResponse({ status: 404, description: 'Not Found' })
  @ApiResponse({ status: 409, description: 'Conflict' })
  async create(@Body() registerProjectDto: RegisterProjectDto): Promise<RegisterProjectEntity> {
    const created = await this.registerProjectService.create(registerProjectDto);
    return created;
  }
}