import { NestFactory } from '@nestjs/core';
import { DocumentBuilder, SwaggerModule } from '@nestjs/swagger';
import * as bodyParser from 'body-parser';
import { WsAdapter } from '@nestjs/platform-ws';
import { AppModule } from './app.module';
import { ValidationPipe } from '@nestjs/common';

async function bootstrap() {
  const app = await NestFactory.create(AppModule);
  app.enableCors({ origin: true, credentials: true });
  // Body Parser Limits
  app.use(bodyParser.json({ limit: '50mb' }));
  app.use(bodyParser.urlencoded({ limit: '50mb', extended: true }));
  // Fix for: API's TicketCtrl POST & application/x-www-form-urlencoded
  // See: https://stackoverflow.com/questions/18710225/node-js-get-raw-request-body-using-express
  app.use(bodyParser.raw({ inflate: true, limit: '50mb', type: 'multipart/form-data' }));
  app.useWebSocketAdapter(new WsAdapter(app));
  //TODO: Disabled
  //app.useGlobalPipes(new ValidationPipe());
  const options = new DocumentBuilder()
    .setTitle('dVITA Helper API')
    .setDescription('dVITA Portal Helper API')
    .setVersion('1.0')
    .addBearerAuth()
    .build();
  const document = SwaggerModule.createDocument(app, options);
  SwaggerModule.setup('api-doc', app, document);

  await app.listen(process.env.API_HTTP_PORT || 3000, '0.0.0.0');
  console.log(`Application (${process.env.NODE_ENV}) is running on: ${await app.getUrl()}`);
}
bootstrap();
