import { u, wallet } from '@cityofzion/neon-core';

export function verifySignatureNeo(
  message: string,
  { publicKey, data, salt }: { data: string, publicKey: string, salt: string },
): string {
  const messageHex = u.str2hexstring(salt + message);
  const lengthHex = u.num2VarInt(messageHex.length / 2);
  const isValidSignature = wallet.verify('010001f0' + lengthHex + messageHex + '0000', data, publicKey);
  if (!isValidSignature) {
    throw new Error('Invalid signature');
  }
  const signerAddress = wallet.getAddressFromScriptHash(wallet.getScriptHashFromPublicKey(publicKey));
  return signerAddress;
}
