import { IsInt, IsString, IsOptional } from 'class-validator';

export class SignatureWithoutPayload {
  @IsString()
  readonly signature!: string;

  @IsString()
  readonly publicKey!: string;

  @IsString()
  readonly salt!: string;
}

export class SignedPayload extends SignatureWithoutPayload {
  readonly payload: any;
}
