import { CanActivate, ExecutionContext, Injectable } from '@nestjs/common';
import { Request } from 'express';
import { decode, sign, verify } from 'jsonwebtoken';
import { Observable } from 'rxjs';
import { verifySignatureNeo } from './utils/verifySignatureNeo';

const secret = 'XeBNSVZOqJ8YLDRMjkrL2Pxf2bgiVDBE';
const tokenMaxAge = "1 day";

const messagePrefix = `Welcome to dVITA! Please sign this message to log in. This request will NOT trigger a blockchain transaction and does NOT require any fees. Nonce:`;

@Injectable()
export class AuthGuard implements CanActivate {
    canActivate(context: ExecutionContext): boolean | Promise<boolean> | Observable<boolean> {
        const req = context.switchToHttp().getRequest();
        return !!getAuthTokenSigner(req);
    }
}

export function createSignableToken() {
    return {
        signable: sign({ nonce: Math.floor(Math.random() * 1000000) }, secret),
        prefix: messagePrefix,
    };
}

export function getAuthTokenSigner(req: Request): string {
    const rawToken = (req.headers.authorization || '').replace(/^Bearer /, '');
    if (!rawToken) {
        throw new Error('Missing auth token');
    }
    const token = decode(rawToken);
    if (!token) {
        throw new Error('Could not decode auth token');
    }
    if (typeof token === 'string') {
        throw new Error('Incorrect auth token type');
    }
    if (!token.signable) {
        throw new Error('Signable token missing');
    }
    if (!Array.isArray(token.signature)) {
        throw new Error('Incorrect type for signature');
    }
    const walletRaw = token.signature[0];
    if (walletRaw !== 'dvita') {
        throw new Error('Unsupported wallet');
    }
    const signable = verify(token.signable, secret, { maxAge: tokenMaxAge });
    if (!signable) {
        throw new Error('Could not verify signable token');
    }
    if (typeof signable === 'string') {
        throw new Error('Incorrect type of signable token');
    }
    const signedMessage = `${messagePrefix}${signable.nonce}`;
    const signature = token.signature[1];

    return verifySignatureNeo(signedMessage, signature)
}

function assertNever(val: never): never {
    throw new Error('This branch should never be reached');
}
