import { verifySignature } from '@/utils/verifySignature';
import { Body, Controller, Get, HttpException, HttpStatus, Param, Post } from '@nestjs/common';
import { ApiBearerAuth, ApiResponse, ApiTags } from '@nestjs/swagger';
import { SignedPayload } from './dto/signed-payload.dto';
import { AuthMessage } from './entities/auth-message.entity';
import { createSignableToken } from './auth.guard';

const messageExpirationTime = 24 * 60 * 60 * 1000;

@ApiBearerAuth()
@ApiTags('auth')
@Controller('auth')
export class AuthController {
  private messagesToSign: Partial<Record<string, { message: string, generatedAt: number }>> = {};

  @Get('/token')
  getToken(){
      return createSignableToken();
  }
}
