import { Module, OnModuleInit } from '@nestjs/common';
import { UserInfoModule } from './user-info/user-info.module';
import { AuthModule } from './auth/auth.module';
import { TypeOrmModule } from '@nestjs/typeorm';
import { OpenApiModule } from './openapi/openapi.module';
import { SocialAuthModule } from './social-auth/social.auth.module';
import { SocialRewardsModule } from './social-rewards/social.rewards.module';
import { RegisterProjectModule } from './register-project/register-project.module';

@Module({
  imports: [
    AuthModule,
    UserInfoModule,
    OpenApiModule,
    SocialAuthModule,
    SocialRewardsModule,
    RegisterProjectModule,
    TypeOrmModule.forRoot({
      type: 'postgres',
      host: process.env.API_DB_HOST,
      port: parseInt(process.env.API_DB_PORT as string, 10),
      database: process.env.API_DB_DATABASE,
      username: process.env.API_DB_USER,
      password: process.env.API_DB_PASSWORD,
      entities: [
        __dirname + '/**/*.entity.js',
      ],
      migrations: ['dist/migrations/*{.ts,.js}'],
      migrationsRun: true,
      synchronize: true,
      retryAttempts: 100,
      retryDelay: 5000,
      'cli': {
        migrationsDir: 'src/migration',
      }
    }),
  ],
})
export class AppModule implements OnModuleInit {
  onModuleInit(): any {
    console.log({
      host: process.env.API_DB_HOST,
      port: parseInt(process.env.API_DB_PORT as string, 10),
      database: process.env.API_DB_DATABASE,
      username: process.env.API_DB_USER,
      password: process.env.API_DB_PASSWORD?.replace(/./g, '*'),
    });
  }
}
