// Copyright (C) 2015-2021 The Neo Project.
// 
// The neo is free software distributed under the MIT software license, 
// see the accompanying file LICENSE in the main directory of the
// project or http://www.opensource.org/licenses/mit-license.php 
// for more details.
// 
// Redistribution and use in source and binary forms with or without
// modifications are permitted.

namespace Neo.Plugins
{
    /// <summary>
    /// A plug-in interface for logs.
    /// </summary>
    public interface ILogPlugin
    {
        /// <summary>
        /// Writes a new log to the plugin.
        /// </summary>
        /// <param name="source">The source of the log. Used to identify the producer of the log.</param>
        /// <param name="level">The level of the log.</param>
        /// <param name="message">The message of the log.</param>
        void Log(string source, LogLevel level, object message);
    }
}
