﻿using System;
using System.IO;
using System.Text;
using System.Text.Json;

using RabbitMQ.Client;

namespace broadcaster.Models
{
    class Broadcaster
    {
        public void StartBroadcasting()
        {
            string configPath = @"config.json";
            Config config = null;

            if (File.Exists(configPath))
            {
                config = JsonSerializer.Deserialize<Config>(File.ReadAllText(configPath));

                Uri uri = new Uri(config.MqEndpoint);

                Console.WriteLine($"Connecting to: {uri.ToString()}");

                var factory = new ConnectionFactory() {
                    Uri = uri
                };

                using (var connection = factory.CreateConnection())
                using (var channel = connection.CreateModel())
                {
                    channel.ExchangeDeclare(exchange: "logs", type: ExchangeType.Fanout);

                    var body = Encoding.UTF8.GetBytes(DateTime.Now.ToString("HH.mm.ss"));
                    channel.BasicPublish(exchange: "logs", routingKey: "", basicProperties: null, body: body);
                    Console.WriteLine(DateTime.Now.ToString("HH.mm.ss"));
                }

                Console.WriteLine(" Press [enter] to exit.");
                Console.ReadLine();
            }
            else
            {
                throw new FileNotFoundException("config.json not found");
            }
        }
    }
}
